<?php

namespace App\Models\Task\Task;

use Illuminate\Database\Eloquent\Model;

class Task extends Model 
{

    protected $table = 'tasks';
    public $timestamps = false;
    protected $fillable = array('title', 'description', 'updated_at', 'deleted_at');

    public function completions()
    {
        return $this->morphToMany('Completion', 'completeable');
    }

    public function assignees()
    {
        return $this->morphToMany('Assign', 'assignable');
    }

    public function owner()
    {
        return $this->belongsTo('User', 'owner_id');
    }

}